package ga.view.streaming.nodes;

import com.jme3.bounding.BoundingBox;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue.Bucket;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;

/**
 * This node is a zone for up/downvoting individuals by dropping them on this.
 * 
 * @since 12.08.2012
 * @author Stephan Dreyer
 */
public class EvaluationNode extends Node {
  private final Geometry geometry;
  private float scaleTo = 1.0f;
  private final float speed = 6f;

  private boolean mouseOver;

  private final float orgScaleX;

  /**
   * Instantiates a new evaluation node.
   * 
   * @param name
   *          the name
   * @param geo
   *          the geometry
   * 
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public EvaluationNode(final String name, final Geometry geo) {
    super(name);
    this.geometry = geo;
    attachChild(geo);
    orgScaleX = geometry.getLocalScale().x;
    scaleTo = orgScaleX;

    setModelBound(new BoundingBox(Vector3f.ZERO, new Vector3f(1f, 1f, 1f)));

    updateModelBound();

    setQueueBucket(Bucket.Transparent);
  }

  @Override
  public void updateLogicalState(final float tpf) {
    super.updateLogicalState(tpf);

    if (geometry.getLocalScale().x < scaleTo) {
      float scale = geometry.getLocalScale().x + (speed * tpf);

      if (scale > scaleTo) {
        scale = scaleTo;
      }

      geometry.setLocalScale(scale, scale, scale);
      geometry.updateGeometricState();

    } else if (geometry.getLocalScale().x > scaleTo) {
      float scale = geometry.getLocalScale().x - (speed * tpf);

      if (scale < scaleTo) {
        scale = scaleTo;
      }

      geometry.setLocalScale(scale, scale, scale);
      geometry.updateGeometricState();
    }
  }

  /**
   * Sets the mouse over.
   * 
   * @param mouseOver
   *          the new mouse over
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public void setMouseOver(final boolean mouseOver) {
    this.mouseOver = mouseOver;
    if (mouseOver) {
      scaleTo = orgScaleX * 2;
    } else {
      scaleTo = orgScaleX;
    }
  }

  /**
   * Checks if mouse is over.
   * 
   * @return true, if mouse is over
   * @since 12.08.2012
   * @author Stephan Dreyer
   */
  public boolean isMouseOver() {
    return mouseOver;
  }
}
